package com.agilex.healthcare.veteranappointment.datalayer.appointment;

import com.agilex.healthcare.veteranappointment.datalayer.PersistenceObject;
import com.agilex.healthcare.veteranappointment.datalayer.Transformable;
import com.agilex.healthcare.veteranappointment.datalayer.patient.PatientPo;
import com.agilex.healthcare.veteranappointment.domain.Provider;
import gov.va.vamf.scheduling.communitycare.domain.FormAddress;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Id;
import javax.persistence.GeneratedValue;
import javax.persistence.Column;
import javax.persistence.Transient;

@Entity
@Table(name = ProviderPo.TABLE_NAME)
@XStreamAlias("Provider")
public class ProviderPo extends PersistenceObject implements Transformable<Provider> {

	public static final String TABLE_NAME = "PREFERRED_PROVIDER";
	private String preferredProviderId;
	private String firstName;
	private String lastName;
	private String practiceName;

	private String providerStreet;
	private String providerCity;
	private String providerState;
	private String providerZipCode;
	private int preferredOrder;

	public ProviderPo(){
	}

	public ProviderPo(Provider dto, int preferredOrder) {
		setPreferredProviderId(dto.getPreferredProviderId());
		setFirstName(dto.getFirstName());
		setLastName(dto.getLastName());
		setPracticeName(dto.getPracticeName());
		setProviderStreet(dto.getProviderStreet());
		setProviderCity(dto.getProviderCity());
		setProviderState(dto.getProviderState());
		setProviderZipCode(dto.getProviderZipCode());
		setPreferredOrder(preferredOrder);
	}


	@Id
	@GeneratedValue(generator="cc_preferred_provider_id_generator")
	@GenericGenerator(name="cc_preferred_provider_id_generator", strategy = "uuid")
	@Column(name = "PREFERRED_PROVIDER_ID", nullable = false)
	public String getPreferredProviderId() {
		return super.getId();
	}

	public void setPreferredProviderId(String preferredProviderId) {
		super.setId(preferredProviderId);
	}

	@Column(name = "FIRST_NAME", nullable = true)
	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	@Column(name = "LAST_NAME", nullable = true)
	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	@Column(name = "PRACTICE_NAME", nullable = true)
	public String getPracticeName() {
		return practiceName;
	}

	public void setPracticeName(String practiceName) {
		this.practiceName = practiceName;
	}

	@Column(name = "PROVIDER_STREET", nullable = true)
	public String getProviderStreet() {
		return providerStreet;
	}

	public void setProviderStreet(String providerStreet) {
		this.providerStreet = providerStreet;
	}

	@Column(name = "PROVIDER_CITY", nullable = true)
	public String getProviderCity() {
		return providerCity;
	}

	public void setProviderCity(String providerCity) {
		this.providerCity = providerCity;
	}

	@Column(name = "PROVIDER_STATE", nullable = true)
	public String getProviderState() {
		return providerState;
	}

	public void setProviderState(String providerState) {
		this.providerState = providerState;
	}

	@Column(name = "PROVIDER_ZIPCODE", nullable = true)
	public String getProviderZipCode() {
		return providerZipCode;
	}

	public void setProviderZipCode(String providerZipCode) {
		this.providerZipCode = providerZipCode;
	}

	@Column(name = "PREFERRED_ORDER", nullable = false)
	public int getPreferredOrder() {
		return preferredOrder;
	}

	public void setPreferredOrder(int preferredOrder) {
		this.preferredOrder = preferredOrder;
	}

	@Override
	public Provider create() {
		Provider dto = new Provider();
		dto.setPreferredProviderId(preferredProviderId);
		dto.setFirstName(firstName);
		dto.setLastName(lastName);
		dto.setPracticeName(practiceName);
		dto.setProviderStreet(providerStreet);
		dto.setProviderState(providerState);
		dto.setProviderCity(providerCity);
		dto.setProviderZipCode(providerZipCode);
		dto.setPreferredOrder(getPreferredOrder());
		return dto;
	}

	@Transient
	public boolean isValid() {
		return (this.getFirstName() != null
				|| this.getLastName() != null
				|| this.getPracticeName() != null
				|| this.getProviderStreet() != null
				|| this.getProviderCity() != null
				|| this.getProviderState() != null
				|| this.getProviderZipCode() != null);
	}
}